function contours = contourstruct(c)
% contours = contourstruct(c)
% 
% Reads a contour matrix, and converts it to a struct, for easier plotting.
% Typically contour matrices are creatd by c = contourc( surf ).
% 
% The outpur struc has x and y fields, with the coordinates of each contour
% line.
% 
% see also plotcontourstruct, plotcontours, contour, contourc
% 
% Created by Yannick Kremer 2010
% University of Strathclyde
% Glasgow
% mail@ykremer.com


% figure
contours = struct('x', 0, 'y', 0);
idx = 1;
while length(c) > 0,
    cval = c(1,1);
    ccount = c(2,1);

    x = c(1, 2 : ccount+1);
    y = c(2, 2 : ccount+1);
    
    contours( idx ).x = x;
    contours( idx ).y = y;
    idx = idx+1;
%     plot( x,y, '-'); hold on

    c = c( :, ccount+2:end);
end